<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DestinatarioNotificacion extends Model 
{

    protected $table = 'destinatarios_notificaciones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('notificacion_id', 'user_id', 'name', 'email');
    protected $visible = array('notificacion_id', 'user_id', 'name', 'email');

    public function notificacion()
    {
        return $this->belongsTo('Notificacion', 'notificacion_id')->withTrashed();
    }

}